/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

public class WSFieldParameter {
    public static final int WS_PARAMETER_INTEGER = 1;
    public static final int WS_PARAMETER_STRING = 2;
    public static final int WS_PARAMETER_BOOLEAN = 4;
    public static final int WS_PARAMETER_FLOAT = 8;
    public static final int WS_PARAMETER_TIME = 16;
    public static final int WS_PARAMETER_ATTACHMENT = 32;
    public static final String WS_PARAMETER_INTEGER_STRING = "Integer";
    public static final String WS_PARAMETER_STRING_STRING = "String";
    public static final String WS_PARAMETER_BOOLEAN_STRING = "Boolean";
    public static final String WS_PARAMETER_FLOAT_STRING = "Float";
    public static final String WS_PARAMETER_TIME_STRING = "Time";
    public static final String WS_PARAMETER_ATTACHMENT_STRING = "Attachment";
    public static final String WS_PARAMETER_ARRAY_STRING = "[]";
    private String m_name = null;
    private int m_type = -1;
    private boolean m_bArray = false;
    private boolean m_bIn = false;
    private boolean m_bOut = false;

    public WSFieldParameter() {
    }

    public WSFieldParameter(String name, String type, boolean bArray, boolean bIn, boolean bOut) {
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public void setArray(boolean bArray) {
        this.m_bArray = bArray;
    }

    public void setIn(boolean bIn) {
        this.m_bIn = bIn;
    }

    public void setOut(boolean bOut) {
        this.m_bOut = bOut;
    }

    String typeString() {
        String s = new String();
        if (this.m_type == 32) {
            s = s + WS_PARAMETER_ATTACHMENT_STRING;
        } else if (this.m_type == 4) {
            s = s + WS_PARAMETER_BOOLEAN_STRING;
        } else if (this.m_type == 1) {
            s = s + WS_PARAMETER_INTEGER_STRING;
        } else if (this.m_type == 8) {
            s = s + WS_PARAMETER_FLOAT_STRING;
        } else if (this.m_type == 2) {
            s = s + WS_PARAMETER_STRING_STRING;
        } else if (this.m_type == 16) {
            s = s + WS_PARAMETER_TIME_STRING;
        }
        if (this.m_bArray) {
            s = s + WS_PARAMETER_ARRAY_STRING;
        }
        return s;
    }

    public String getName() {
        return this.m_name;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isArray() {
        return this.m_bArray;
    }

    public boolean isInParam() {
        return this.m_bIn;
    }

    public boolean isOutParam() {
        return this.m_bOut;
    }

    public String toString() {
        String s = new String();
        s = s + this.typeString() + " ";
        s = s + this.m_name + " ";
        if (this.m_bIn & this.m_bOut) {
            s = s + "in/out";
        } else if (this.m_bIn) {
            s = s + "in";
        } else if (this.m_bOut) {
            s = s + "out";
        }
        return s;
    }

    boolean isSameNameAndType(WSFieldParameter fieldParam) {
        if (this.m_name != null && fieldParam.getName() != null && this.m_name.compareTo(fieldParam.getName()) != 0) {
            return false;
        }
        if (this.m_type != fieldParam.getType()) {
            return false;
        }
        return this.m_bArray == fieldParam.isArray();
    }
}

